package gov.va.genisis2.bo;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

/**
 * The Class BusinessHelper.
 */
public final class BusinessHelper {

	private BusinessHelper() {
		throw new IllegalAccessError("BusinessHelper class");
	}
	
	/**
	 * This method is used to get today's date and time.
	 * 
	 * @return Timestamp This returns both date and time.
	 */
	public static Timestamp getTodaysDate() {
		Calendar cal = Calendar.getInstance();
		return new java.sql.Timestamp(cal.getTimeInMillis());
	}

	/**
	 * This method is used to handle request payload.
	 * 
	 * @param request
	 *            The Request
	 * @return Request This returns request payload.
	 */
	public static Request handleRequestPayload(Request request) {

		if (request != null) {
			request.setProcessId(0);
			request.setStatusDescription("Draft");
			request.setCreatedOn(getTodaysDate());
			
			if (request.getSourceID() >0) {
			Source source = new Source();
			source.setId(request.getSourceID());
			request.setSource(source);
			}
			
			if ( request.getStudyApprovalID() >0 ){
			StudyApproval studyApproval = new StudyApproval();
			
			studyApproval.setId(request.getStudyApprovalID());
			request.setStudyApproval(studyApproval);
			}
			
			if (request.getRequestTypeID() >0) {
			RequestType requestType = new RequestType();
			requestType.setId(request.getRequestTypeID());
			request.setRequestType(requestType);
			}
		
		}
		return request;
	}

	/**
	 * This method is used to handle studyApproval payload.
	 * 
	 * @param studyApproval
	 *            The studyApproval
	 * @return StudyApproval This returns studyApproval payload.
	 */
	public static StudyApproval handleStudyApprovalPayload(
			StudyApproval studyApproval) {
		if (studyApproval != null) {
			List<Integer> lst = studyApproval.getAssociatedApprovals();
			for (Integer study : lst) {
				if (lst.indexOf(study) == 0)
					studyApproval.setAssociatedStudyApproval1(study);
				else if (lst.indexOf(study) == 1)
					studyApproval.setAssociatedStudyApproval2(study);
				else if (lst.indexOf(study) == 2)
					studyApproval.setAssociatedStudyApproval3(study);
			}
			studyApproval.setCreatedOn(getTodaysDate());
			studyApproval.setProcessId(999999999);
			studyApproval.setApprovalIdObtained(studyApproval.getObtained());
		}
		return studyApproval;
	}

	/**
	 * This method is used to handle commentHistory payload.
	 * 
	 * @param commentHistory
	 *            The commentHistory
	 * @return CommentHistory This returns comment history payload.
	 */
	public static CommentHistory handleCommentHistoryPayload(
			CommentHistory commentHistory) {
		return commentHistory;
	}

	/**
	 * This method is used to prepare list of studyApproval response payload.
	 * 
	 * @param studyApprovalList
	 *            The studyApprovalList
	 * @return the list of studayApproval payload.
	 */
	public static List<StudyApproval> prepareStudyApprovalResponsePayload(
			List<StudyApproval> studyApprovalList) {

		if (studyApprovalList == null || studyApprovalList.isEmpty())
			return Collections.emptyList();

		List<Integer> associatedStudyApprovals;

		for (StudyApproval studyApproval : studyApprovalList) {
			int memeberId = studyApprovalList.indexOf(studyApproval);
			associatedStudyApprovals = new ArrayList<>();
			if (studyApproval.getAssociatedStudyApproval1() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval1());
			if (studyApproval.getAssociatedStudyApproval2() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval2());
			if (studyApproval.getAssociatedStudyApproval3() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval3());

			studyApprovalList.get(memeberId).setAssociatedApprovals(
					associatedStudyApprovals);
			studyApprovalList.get(memeberId).setObtained(
					studyApproval.getApprovalIdObtained());
		}
		return studyApprovalList;
	}

	/**
	 * This method is used to prepare list of commentHistory response payload.
	 * 
	 * @param commentHistoryList
	 *            The commentHistoryList
	 * @return the list of commentHistory payload.
	 */
	public static List<CommentHistory> prepareCommentHistoryResponsePayload(
			List<CommentHistory> commentHistoryList) {

		if (commentHistoryList == null || commentHistoryList.isEmpty())
			return Collections.emptyList();

		return commentHistoryList;
	}

	/**
	 * This methos is used to prepare list of request response payload.
	 * 
	 * @param requestList
	 *            The requestList
	 * @return the list of request payload.
	 */
	public static List<Request> prepareRequestResponsePayload(
			List<Request> requestList) {

		if (requestList == null || requestList.isEmpty())
			return Collections.emptyList();

		for (Request request : requestList) {
			int memeberId = requestList.indexOf(request);
			requestList.get(memeberId).setRequestTypeID(request.getRequestType().getId());
			requestList.get(memeberId).setSourceID(request.getSource().getId());
			requestList.get(memeberId).setStudyApprovalID(request.getStudyApproval().getId());
			requestList.get(memeberId).setComments(request.getComments());
		}
		return requestList;
	}
}
